  
  -- --[[ Turret creator ]]--
	local function TurretMount (turret_name,  tbl , turret_)
	tbl.category = CAT_GUN_MOUNT
	tbl.name = turret_name   
	
	tbl.supply = {
		mixes = {{1,1,4}},
		count = 800,
	}
	if tbl.mixes then
		tbl.supply.mixes = tbl.mixes
		tbl.mixes = nil
	end
	if tbl.count then
		tbl.supply.count = tbl.count
		tbl.count = nil
	end
	tbl.gun = {
		max_burst_length = 30,
		rates = {1150}, -- unsynchronized mount
		recoil_coeff =  0.7*1.3,
		barrel_circular_error = 0.0002,
		barrels_count = 1,
		trigger = {name ="GunTrigger"}  
	}
	tbl.effective_fire_distance = 250;
	
	tbl.ejector_pos = tbl.ejector_pos or {0.0, 0.00, -0.5}
	tbl.ejector_dir = tbl.ejector_dir or {0, 0, -1}
	--tbl.effect_arg_number = tbl.effect_arg_number or 436
	tbl.supply_position = tbl.supply_position or {0, 0.3, -0.3}
	tbl.aft_gun_mount = false
	tbl.muzzle_pos = {0, 0, 0} -- all position from connector
	tbl.azimuth_initial = tbl.azimuth_initial or 0
	tbl.elevation_initial = tbl.elevation_initial or 0
	tbl.turret = turret_
	tbl.effects = {
        {name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
        {name = "SmokeEffect"},
    }

	return declare_weapon(tbl)  
end
    
    Guns_ext = {
	-- Nose MG top left
		Browning303({
            muzzle_pos_connector = "GUN_1",
            --effect_arg_number = 350,
            count = 1000,
			mixes = {{3,3,3,2,4}},
            azimuth_initial = 0.0,
            elevation_initial = 0.0,
            supply_position = {-0.385, -0.179, -4.205},
            ejector_pos_connector = nil,
            ejector_dir           = {0, 1, 0},
            drop_cartridge        = 0,--204,
        }),

	-- Nose MG top right
        Browning303({
            muzzle_pos_connector = "GUN_2",
            --effect_arg_number = 433,
            count = 1000,
			mixes = {{3,3,3,2,4}},
            azimuth_initial = 0.0,
            elevation_initial = 0.0,
            supply_position = {-0.385, -0.179, -4.205},
            ejector_pos_connector = nil,
            ejector_dir           = {0, 1, 0},
            drop_cartridge        = 0,
        }),

	-- Midupper MG  right
		Browning303({
			muzzle_pos_connector = "GUN_7",
			--effect_arg_number = 434,
			count = 1000,
			mixes = {
				{3,3,3,3,2},
			},
			azimuth_initial = 180.0,
			elevation_initial = 0.0,
			supply_position = {-0.385, -0.179, -4.205},
            ejector_pos_connector = nil,
			ejector_dir           = {0, -0.33, -0.33},
			drop_cartridge        = 0,
		}),

		-- Midupper MG left
        Browning303({
            muzzle_pos_connector = "GUN_8",
         --  effect_arg_number = 434,
            count = 1000,
			mixes = {
				{3,3,3,3,2},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-0.385, -0.179, -4.205},
			ejector_pos_connector = nil,
            ejector_dir           = {0, -0.33, -0.33},
            drop_cartridge        = 0,
        }),

		-- Tail MG rear left top
        Browning303({
            muzzle_pos_connector = "GUN_5",
           -- effect_arg_number = 435,
            count = 2500,
			mixes = {
				{4},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-0.385, -0.179, -4.205},
            ejector_pos_connector = {0, -0.5 ,0},
            ejector_dir           = {0, -0.33, -0.33},
            drop_cartridge        = 205,
        }),

		-- Tail MG rear left bottom
        Browning303({
            muzzle_pos_connector = "GUN_6",
           -- effect_arg_number = 436,
            count = 2500,
			mixes = {
				{3,3,3,3,2},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-12.0, -0.179, -4.205},
            ejector_pos_connector = {0, -0.5, 0},
            ejector_dir           = {0, -0.33, -0.33},
            drop_cartridge        = 205,
         }),
		
		-- Tail MG left
        Browning303({
            muzzle_pos_connector = "GUN_4",
          --  effect_arg_number = 1004,
			count = 2500,
			mixes = {
				{4},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-12.0, -0.179, 4.205},
            ejector_pos_connector = nil,
            ejector_dir           = {0, 1, 0},
            drop_cartridge        = 205,

        }),

		-- Tail MG right
		Browning303({
            muzzle_pos_connector = "GUN_3",
			--effect_arg_number = 1004,
			count = 2500,
			mixes = {
				{4},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-12.0, -0.179, 4.205},
            ejector_pos_connector = {0, 0,-0.5},
            ejector_dir           = {0, 5, 0},
            drop_cartridge        = 205,
        }),
		
	-- MID UPPER TURRET FN.50
		TurretMount ("LANC_MID_UPPER_R", --0 
						{
							gun = {
								supply = {
									shells = turret_ammo,
									mixes = {
										{3,3,3,2,4},
									},
									count = 1000,
								},
								max_burst_length = 300,
								rates = {1150}, -- unsynchronized mount
								recoil_coeff =  0.7*1.3,
								barrel_circular_error = 0.0002,
								barrels_count = 1,
								trigger = {name ="GunTrigger"},
								ejector_pos = nil,
								ejector_dir = {-1.0, 0.0, 0.0},
							},
							--category = 8,
							muzzle_pos_connector = "GUN_7",
							azimuth_initial = 180.0,
							elevation_initial = 0.0,
							aft_gun_mount = false,
							-- effects = {
							-- 	{name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
							-- 	{name = "SmokeEffect"},
							-- }

						} , 
						{	
							name = "Top_turret",
							H_Arg = 1005,				-- horizontal rotation argument
							V_Arg = 1006,				-- vertical rotation argument
							H_Min = -180.0,				-- minimum horizontal gun deflection (degrees)
							H_Max =  180.0,				-- maximum horizontal gun deflection (degrees)
							V_Min =  -15.0, 			-- minimum vertical gun deflection (degrees)
							V_Max =  60.0,				-- maximum vertical gun deflection (degrees)
							H_Vel =  90.0,				-- horizontal gun rotation speed
							V_Vel =  70.0,
							SecondGun = 1,
							crewMemberInCommandIdx	= 6, -- crew member controlling this turret 
						}
					),



		TurretMount ("LANC_MID_UPPER_L", 				--1
						{
							gun = {
								supply = {
									shells = turret_ammo,
									mixes = {
										{3,3,3,2,4},
									},
									count = 1000,
								},
								max_burst_length = 300,
								rates = {1150}, -- unsynchronized mount
								recoil_coeff =  0.7*1.3,
								barrel_circular_error = 0.0002,
								barrels_count = 1,
								trigger = {name ="GunTrigger"},
								ejector_pos = nil,
								ejector_dir = {-1.0, 0.0, 0.0},
							},
							--category = 8,
							muzzle_pos_connector = "GUN_8",
							--effect_arg_number = 1004,
							azimuth_initial = 180.0,
							elevation_initial = 0.0,
							aft_gun_mount = false,
						} , 
						{	
							name = "Top_turret",							
							SlaveGun = true,
						}
					),



		-- REAR TURRET FN.20
		-----------------------------------
		-- right side of the turret (R1 and R2 are the guns doing the aiming and rotating the turret for AI)
		-- left side are locked and can't move independently ( max and min h and v are all 0), but still shoot
		-- when aligned on target by the right side's action.  
		-- This gets around DCS's apparent limitation of 2 guns per turret
		-----------------------------------
		TurretMount ("LANC_AFT_R1", --2 
					{
						gun = {
							supply = {
								shells = turret_ammo,

								mixes = {
									{3},
								},
								count = 2500,
							},
							max_burst_length = 300,
							rates = {1150}, -- unsynchronized mount
							recoil_coeff =  0.7*1.3,
							barrel_circular_error = 0.0002,
							trigger = {name ="GunTrigger"},
							ejector_pos = {0.0, 0.0, -0.5},
							ejector_dir = {-1.0, 0.0, 0.0},
						},
						category = 8,
						muzzle_pos_connector = "GUN_3",
						effect_arg_number = 1004,
						azimuth_initial   = 180.0,
						elevation_initial = 0.0,
						aft_gun_mount     = false,
						-- effects = {
						-- 	{name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
						-- 	{name = "SmokeEffect"},
						-- }

					} , 
					{	
						name = "Aft_turret",
						H_Arg = 1021,				-- horizontal rotation argument
						V_Arg = 1022,				-- vertical rotation argument
						H_Min = -94.0,				-- minimum horizontal gun deflection (degrees)
						H_Max =  94.0,				-- maximum horizontal gun deflection (degrees)
						V_Min =  -45.0, 			-- minimum vertical gun deflection (degrees)
						V_Max =  60.0,				-- maximum vertical gun deflection (degrees)
						H_Vel =  90.0,				-- horizontal gun rotation speed
						V_Vel =  70.0,
						SecondGun = 3,
						crewMemberInCommandIdx	= 7, -- crew member controlling this turret 
					}
				),


		TurretMount ("LANC_AFT_R2", 				--3
					{						
						gun = {
							supply = {
								shells = turret_ammo,
								mixes = {
									{3,3,3,3,2},
								},
								count = 2500,
							},
							max_burst_length = 300,
							rates = {1150}, -- unsynchronized mount
							recoil_coeff =  0.7*1.3,
							barrel_circular_error = 0.0002,
							trigger = {name ="GunTrigger"},
							ejector_pos = {0.0, 0.0, -0.5},
							ejector_dir = {-1.0, 0.0, 0.0},
						},
						muzzle_pos_connector = "GUN_4",
						azimuth_initial = 180.0,
						elevation_initial = 0.0,
						aft_gun_mount = false,
					} , 
					{	
						name = "Aft_turret",							
						SlaveGun = true,
					}
		 		),	
		
		TurretMount ("LANC_AFT_L1", 				--4
					{
						gun = {
							supply = {
								shells = turret_ammo,
								mixes = {
									{4},
								},
								count = 2500,
							},
							max_burst_length = 300,
							rates = {1150}, -- unsynchronized mount
							recoil_coeff =  0.7*1.3,
							barrel_circular_error = 0.0002,
							barrels_count = 1,
							trigger = {name ="GunTrigger"},
							ejector_pos = {0.0, 0.0, -0.5},
							ejector_dir = {-1.0, 0.0, 0.0},
						},
						muzzle_pos_connector = "GUN_5",
						count = 2500,
						azimuth_initial = 180.0,
						elevation_initial = 0.0,
						aft_gun_mount		  = false,
					} , 
					{	
												name = "Aft_turret",
						H_Arg = 1021,				-- horizontal rotation argument
						V_Arg = 1022,				-- vertical rotation argument
						H_Min = -94.0,				-- minimum horizontal gun deflection (degrees)
						H_Max =  94.0,				-- maximum horizontal gun deflection (degrees)
						V_Min =  -45.0, 			-- minimum vertical gun deflection (degrees)
						V_Max =  60.0,				-- maximum vertical gun deflection (degrees)
						H_Vel =  90.0,				-- horizontal gun rotation speed
						V_Vel =  70.0,
						SecondGun = 5,
						crewMemberInCommandIdx	= 7, -- crew member controlling this turret 
						name = "Aft_turret2",							
					}
				),
		TurretMount ("LANC_AFT_L2", 				--5
					{
						gun = {
							supply = {
								shells = turret_ammo,
								mixes = {
									{3,3,3,3,2},
								},
								count = 2500,
							},
							max_burst_length = 300,
							rates = {1150}, -- unsynchronized mount
							recoil_coeff =  0.7*1.3,
							barrel_circular_error = 0.0002,
							barrels_count = 1,
							trigger = {name ="GunTrigger"},
							ejector_pos = {0.0, 0.0, -0.5},
							ejector_dir = {-1.0, 0.0, 0.0},
						},
						muzzle_pos_connector = "GUN_6",
						count = 2500,
						azimuth_initial = 180,
						elevation_initial = 0.0,
						aft_gun_mount		  = false,
					} , 
					{	
						name = "Aft_turret2",							
						SlaveGun = true,
					}
				),			
			

		-- FORWARD TURRET FN5
		TurretMount ("LANC_FWD_1", --6 
						{
							gun = {
								supply = {
									shells = turret_ammo,
									mixes = {
										{3,3,3,2,4},
									},
									count = 1000,
								},
								max_burst_length = 300,
								rates = {1150}, -- unsynchronized mount
								recoil_coeff =  0.7*1.3,
								barrel_circular_error = 0.0002,
								barrels_count = 1,
								trigger = {name ="GunTrigger"},
								ejector_pos = {0.0, 0.0, -0.5},
								ejector_dir = {-1.0, 0.0, 0.0},
							},
							category = 8,
							muzzle_pos_connector = "GUN_1",
							azimuth_initial = 0.0,
							elevation_initial = 0.0,
							aft_gun_mount = false,
							-- effects = {
							-- 	{name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
							-- 	{name = "SmokeEffect"},
							-- }

						} , 
						{	
							name = "Fwd_turret",
							H_Arg = 1011,				-- horizontal rotation argument
							V_Arg = 1012,				-- vertical rotation argument
							H_Min = -95.0,				-- minimum horizontal gun deflection (degrees)
							H_Max =  95.0,				-- maximum horizontal gun deflection (degrees)
							V_Min =  -45.0, 			-- minimum vertical gun deflection (degrees)
							V_Max =  60.0,				-- maximum vertical gun deflection (degrees)
							H_Vel =  90.0,				-- horizontal gun rotation speed
							V_Vel =  70.0,
							SecondGun = 6,
							crewMemberInCommandIdx	= 2, -- crew member controlling this turret 
						}
					),
		TurretMount ("LANC_FWD_2", 				--7
						{
							gun = {
								supply = {
									shells = turret_ammo,
									mixes = {
										{3,3,3,2,4},
									},
									count = 1000,
								},
								max_burst_length = 300,
								rates = {1150}, -- unsynchronized mount
								recoil_coeff =  0.7*1.3,
								barrel_circular_error = 0.0002,
								barrels_count = 1,
								trigger = {name ="GunTrigger"},
								ejector_pos = {0.0, 0.0, -0.5},
								ejector_dir = {-1.0, 0.0, 0.0},
							},
							category = 8,
							muzzle_pos_connector = "GUN_2",
						--	effect_arg_number = 1004,
							azimuth_initial = 0.0,
							elevation_initial = 0.0,
							aft_gun_mount = false,
						} , 
						{	
							name = "Fwd_turret",							
							SlaveGun = true,
						}
					),
    }
					


