dofile("Scripts/Database/Weapons/warheads.lua")


-- Common vars --------------------------------------------------------------------------

local turret_ammo = {
    --[[ 1 ]]   "British303_Ball_Mk1c", -- ball
    --[[ 2 ]]   "British303_G_Mk5", -- night dimmed tracer
    --[[ 3 ]]   "British303_W_Mk1z",  -- ap
    --[[ 4 ]]   "British303_B_Mk4z",  -- incendiary
}

----------------------

---------BOMBS----------------


upkeep = {
	D_max = 8000,
	D_min = 0,
	Damage = 700,
	Diam = 1200,
	H_max = 100,
	H_min = -30,
	Head_Type = 0,
	Life_Time = 90,
	M = 4200,
	Name = "Upkeep",
	Nr_max = 1,
	V_max = 250,
	V_min = -1,
	_file = "./Mods/tech/WWII Units/Database/Weapons/torpedoes.lua",
	_origin = "WWII Armour and Technics",
	autopilot = {
		Kdh = 3,
		Kdv = 0,
		Kih = 0,
		Kiv = 2e-05,
		Kph = 4, --28,
		Kpv = 0.03,
		delay = 2,
		fins_limit = 0.25,
		hKp_err_croll = 0,
		hor_spir_on_time = 350,
		hor_spir_period = 30,
		hor_spir_power = 0.4,
		roll_diff_correction = 1,
		steady_depth = 5,
		v_vel_limit = 25,
		vel_proj_div = 10,
		x_fins_limit = 0
	},
	category = 11,
	class_name = "wAmmunition",
	display_name = "Upkeep",
	engine = {
		thrust = 0.1
	},
	fm = {
		A = 2.5,
		I = 6700,
		L = 7.186,
		Ma = 0.2,
		Ma_x = 0.1,
		Mw = 0.4,
		Mw_x = 0.01,
		Sw = 0.5,
		Sww = 0.5,
		caliber = 1.27,
		cx_coeff = { 1, 0.39, 0.38, 0.236, 1.31 },
		dCydA = { 0.07, 0.036 },
		finsTau = 0.02,
		fins_val_div = 10000,
		int_rho_y = 0.5,
		mass = 4200,
		maxAoa = 0.3,
		rho_w = 1013,
		splash_dt = 0.004,
		splash_time = 1.2,
		wind_sigma = 0,
		wind_time = 0,
	},
	mass = 4200,
	model = "upkeep",
	name = "Upkeep",
	scheme = "unguided_torpedo",
	shape_table_data = { {
			file = "upkeep",
			fire = { 0, 1 },
			index = WSTYPE_PLACEHOLDER,
			life = 1,
			name = "upkeep",
			username = "upkeep"
		} },
	user_name = "Upkeep",
	v_mid = 0,
	warhead =  {
		caliber = 1270,
		concrete_factors = { 2, 1, 5 },
		concrete_obj_factor = 2,
		cumulative_factor = 0,
		cumulative_thickness = 0,
		expl_mass = 2994,
		fantom = 0,
		mass = 4200,
		obj_factors = { 1, 1 },
		other_factors = { 1, 1, 1 },
		piercing_mass = 500,
		time_self_destruct = 90
	},--simple_warhead(3000),  --"_G/warheads/G7_A.lua",
	warhead_water = {
		caliber = 1270,
		concrete_factors = { 2, 1, 5 },
		concrete_obj_factor = 2,
		cumulative_factor = 0,
		cumulative_thickness = 0,
		expl_mass = 2994,
		fantom = 0,
		mass = 4200,
		obj_factors = { 1, 1 },
		other_factors = { 1, 1, 1 },
		piercing_mass = 500,
		time_self_destruct = 90
	},
	wsTypeOfWeapon = { 4, 8, 11, "WSTYPE_PLACEHOLDER" },
	ws_type = { 4, 8, 11, "WSTYPE_PLACEHOLDER" }
}
declare_weapon(upkeep)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{UPKEEP}",
	attribute		= upkeep.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= upkeep.Cx,
	Picture			= "upkeep.png",
	displayName		= upkeep.user_name,
	Weight			= upkeep.mass,
	Elements  		=
	{
		{
		Position	=	{0,	-4.0,	0},
		ShapeName = upkeep.model
		}
	},
})


upkeep_dud = {
	D_max = 8000,
	D_min = 0,
	Damage = 0,
	Diam = 1200,
	H_max = 100,
	H_min = -30,
	Head_Type = 0,
	Life_Time = 90,
	M = 4200,
	Name = "Inert Upkeep",
	Nr_max = 1,
	V_max = 250,
	V_min = -1,
	_file = "./Mods/tech/WWII Units/Database/Weapons/torpedoes.lua",
	_origin = "WWII Armour and Technics",
	autopilot = {
		Kdh = 3,
		Kdv = 0,
		Kih = 0,
		Kiv = 2e-05,
		Kph = 4, --28,
		Kpv = 0.03,
		delay = 2,
		fins_limit = 0.25,
		hKp_err_croll = 0,
		hor_spir_on_time = 350,
		hor_spir_period = 30,
		hor_spir_power = 0.4,
		roll_diff_correction = 1,
		steady_depth = 5,
		v_vel_limit = 25,
		vel_proj_div = 10,
		x_fins_limit = 0
	},
	category = 11,
	class_name = "wAmmunition",
	display_name = "Inert Upkeep",
	engine = {
		thrust = 0.1
	},
	fm = {
		A = 2.5,
		I = 6700,
		L = 7.186,
		Ma = 0.2,
		Ma_x = 0.1,
		Mw = 0.4,
		Mw_x = 0.01,
		Sw = 0.5,
		Sww = 0.5,
		caliber = 1.27,
		cx_coeff = { 1, 0.39, 0.38, 0.236, 1.31 },
		dCydA = { 0.07, 0.036 },
		finsTau = 0.02,
		fins_val_div = 10000,
		int_rho_y = 0.5,
		mass = 4200,
		maxAoa = 0.3,
		rho_w = 1013,
		splash_dt = 0.004,
		splash_time = 1.2,
		wind_sigma = 0,
		wind_time = 0,

	},
	mass = 4200,
	model = "upkeep",
	name = "Inert Upkeep",
	scheme = "unguided_torpedo",
	shape_table_data = { {
			file = "upkeep",
			fire = { 0, 1 },
			index = WSTYPE_PLACEHOLDER,
			life = 1,
			name = "upkeep_inert",
			username = "upkeep_inert"
		} },
	user_name = "Inert_Upkeep",
	v_mid = 0,
	warhead =  {
		caliber = 1,
		concrete_factors = { 0, 0, 0 },
		concrete_obj_factor = 2,
		cumulative_factor = 0,
		cumulative_thickness = 0,
		expl_mass = 1,
		fantom = 0,
		mass = 1,
		obj_factors = { 1, 1 },
		other_factors = { 1, 1, 1 },
		piercing_mass = 1,
		time_self_destruct = 90
	},
	warhead_water = {
		caliber = 1,
		concrete_factors = { 0, 0, 0 },
		concrete_obj_factor = 2,
		cumulative_factor = 0,
		cumulative_thickness = 0,
		expl_mass = 1,
		fantom = 0,
		mass = 1,
		obj_factors = { 1, 1 },
		other_factors = { 1, 1, 1 },
		piercing_mass = 1,
		time_self_destruct = 90
	},
	wsTypeOfWeapon = { 4, 8, 11, "WSTYPE_PLACEHOLDER" },
	ws_type = { 4, 8, 11, "WSTYPE_PLACEHOLDER" }
}
declare_weapon(upkeep_dud)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{UPKEEP_INERT}",
	attribute		= upkeep_dud.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= upkeep_dud.Cx,
	Picture			= "upkeep.png",
	displayName		= upkeep_dud.user_name,
	Weight			= upkeep_dud.mass,
	Elements  		=
	{
		{
		Position	=	{0,	-4.0,	0},
		ShapeName = upkeep_dud.model
		}
	},
})



-- UK 22000 lbs "Grand Slam" Bomb -------------------------
grandslam = 
{category = CAT_BOMBS, 
		name = "GrandSlam", 
        user_name = _("22000 lbs Grand Slam Bomb"),
        model           = "grandslam",
        wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
        scheme          = "bomb-common",
        type            = 0,
        mass            = 9979, --kg
        hMin            = 1000.0,
        hMax            = 12000.0,
        Cx              = 0.00056,
        VyHold          = -100.0,
        Ag              = -1.23,
		
        fm	= {
            mass        = 9979,
            caliber     = 1.17,
            cx_coeff    = {1.0, 0.39, 0.38, 0.236, 1.31},
            L           = 1.765,
            I           = 1/12 * 9979 * 1.765 * 1.765,
            Ma          = 0.141338,
            Mw          = 2.244756,
            wind_sigma  = 30,
        },
		
        warhead         = simple_warhead(4309),--, 477
		
        shape_table_data = {
            {
                name    = "22000 lbs Grand Slam Bomb";
                file    = "grandslam";
                life    = 1;
                fire    = {0, 1};
                username = _("22000 lbs Grand Slam"),
                index   = WSTYPE_PLACEHOLDER;
            },
        },
        targeting_data  = {
            char_time   = 20.57, -- characteristic time for sights 
        },
    }
    declare_weapon(grandslam)

    declare_loadout(
		{
		category = CAT_BOMBS, 
		CLSID 			= "{Lanc_Grandslam}", 
		displayName 	= _("22000 lbs Grand Slam"),
		attribute		= grandslam.wsTypeOfWeapon,
		Count 			= 1,
		Cx_pil			= grandslam.Cx,
        Picture 		= "grandslam.png",
        PictureBlendColor = "0xffffffff",
		Weight			= grandslam.mass,
		Elements  		= {
            ShapeName = grandslam.model,
            },
        })
	
-- end of UK 22000 lbs "Grandslam" Bomb -------------------------




-- UK 12000 lbs "Tallboy" Bomb -------------------------
tallboy = 
{category = CAT_BOMBS, name = "Tallboy", user_name = _("12000 lbs Tallboy"),
        model           = "tallboy",
        wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
        scheme          = "bomb-common",
        type            = 0,
        mass            = 5454, --kg
        hMin            = 300.0,
        hMax            = 12000.0,
        Cx              = 0.00056,
        VyHold          = -100.0,
        Ag              = -1.23,
		
        fm	= {
            mass        = 5454,
            caliber     = 0.9652,
            cx_coeff    = {1.0, 0.39, 0.38, 0.236, 1.31},
            L           = 6.4,
            I           = 1/12 * 5454 * 6.4 * 6.4,
            Ma          = 0.141338,
            Mw          = 2.244756,
            wind_sigma  = 30,
        },
		
        warhead         = 
        {
            caliber             = 0.9652, -- meters
            mass			    = 5400,
            piercing_mass       = 2000,
            expl_mass           = 2400,
            other_factors       = { 4.0, 1.5, 0.5 },
            concrete_factors    = { 2.0, 1.0, 0.5 },
            concrete_obj_factor = 1.0,
            obj_factors         = { 1.0, 1.0 },
            cumulative_factor   = 2.1,
            cumulative_thickness = 2,
        },
       -- warhead         = simple_warhead(2400),--, 477
		
        shape_table_data = {
            {
                name    = "12000 lbs Tallboy Bomb";
                file    = "tallboy";
                life    = 1;
                fire    = {0, 1};
                username = _("12000 lbs Tallboy"),
                index   = WSTYPE_PLACEHOLDER;
            },
        },
        targeting_data  = {
            char_time   = 20.57, -- characteristic time for sights 
        },
    }
    declare_weapon(tallboy)

    declare_loadout(
        {
            category = CAT_BOMBS, 
            CLSID = 		"{Lanc_Tallboy}", 
            displayName = _("12000 lbs Tallboy Bomb"),
		    attribute		= tallboy.wsTypeOfWeapon,
		    Count 			= 1,
		    Cx_pil			= tallboy.Cx,
            Picture 		= "tallboy.png",
            PictureBlendColor = "0xffffffff",
		    Weight			= tallboy.mass,
		    Elements  		= {{ShapeName = tallboy.model}},-- Position = {-4.0, -10.0, -4.0},  Rotation = {0,0,0}},
	})
	
-- end of UK 12000 lbs "Tallboy" Bomb -------------------------



-- UK General Purpose High Explosive Bomb, 250lb GP -------------------------
-- MC250 = 
-- {category = CAT_BOMBS, name = "250MC", user_name = _("250MC"),
--         model           = "mc250",
--         wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
--         scheme          = "bomb-common-anim",
--         type            = 0,
--         mass            = 113, --kg
--         hMin            = 300.0,
--         hMax            = 12000.0,
--         Cx              = 0.00056,
--         VyHold          = -100.0,
--         Ag              = -1.23,
		
--         fm	= {
--             mass        = 113,
--             caliber     = 0.3,
--             cx_coeff    = {1.0, 0.39, 0.38, 0.236, 1.31},
--             L           = 1.765,
--             I           = 1/12 * 113 * 1.765 * 1.765,
--             Ma          = 0.141338,
--             Mw          = 2.244756,
--             wind_sigma  = 30,
--         },
		
--         warhead         = simple_warhead(52),--, 477
		
--         shape_table_data = {
--             {
--                 name    = "250 lb Medium Casing Bomb";
--                 file    = "mc250";
--                 life    = 1;
--                 fire    = {0, 1};
--                 username = _("250MC"),
--                 index   = WSTYPE_PLACEHOLDER;
--             },
--         },
--         targeting_data  = {
--             char_time   = 20.57, -- characteristic time for sights 
--         },
--     }
--     declare_weapon(MC250)

--     declare_loadout({category = CAT_BOMBS, CLSID = "{Lanc_250MC}", displayName = _("250 lbs Medium Case Bomb"),
-- 		attribute		= MC250.wsTypeOfWeapon,
-- 		Count 			= 1,
-- 		Cx_pil			= MC250.Cx,
--         Picture 		= "250mc.png",
--         PictureBlendColor = "0xffffffff",
-- 		Weight			= MC250.mass,
-- 		Elements  		= {{ShapeName = MC250.model}},
-- 	})
	
-- end of UK General Purpose High Explosive Bomb, 250 lb GP, 500GP ------------------



-- UK General Purpose High Explosive Bomb, 500lb GP -------------------------
-- MC500 = 
-- {category = CAT_BOMBS, name = "500MC", user_name = _("500MC"),
--         model           = "mc500",
--         wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
--         scheme          = "bomb-common-anim",
--         type            = 0,
--         mass            = 227.0, --kg
--         hMin            = 300.0,
--         hMax            = 12000.0,
--         Cx              = 0.00056,
--         VyHold          = -100.0,
--         Ag              = -1.23,
		
--         fm	= {
--             mass        = 227.0,
--             caliber     = 0.3,
--             cx_coeff    = {1.0, 0.39, 0.38, 0.236, 1.31},
--             L           = 1.765,
--             I           = 1/12 * 227 * 1.765 * 1.765,
--             Ma          = 0.141338,
--             Mw          = 2.244756,
--             wind_sigma  = 30,
--         },
		
--         warhead         = simple_warhead(100),--, 477
		
--         shape_table_data = {
--             {
--                 name    = "500 lb Medium Casing Bomb";
--                 file    = "mc500";
--                 life    = 1;
--                 fire    = {0, 1};
--                 username = _("500MC"),
--                 index   = WSTYPE_PLACEHOLDER;
--             },
--         },
--         targeting_data  = {
--             char_time   = 20.57, -- characteristic time for sights 
--         },
--     }
--     declare_weapon(MC500)

--     declare_loadout({category = CAT_BOMBS, CLSID = "{Lanc_500MC}", displayName = _("500 lbs Medium Case Bomb"),
-- 		attribute		= MC500.wsTypeOfWeapon,
-- 		Count 			= 1,
-- 		Cx_pil			= MC500.Cx,
--         Picture 		= "500mc.png",
--         PictureBlendColor = "0xffffffff",
-- 		Weight			= MC500.mass,
-- 		Elements  		= {{ShapeName = MC500.model}},
-- 	})
    -- end of UK General Purpose High Explosive Bomb, 500 lb GP, 500GP ------------------


-- UK General Purpose High Explosive Bomb, 1000 lb GP, 1000GP -------------------------
GP1000 = 
{category = CAT_BOMBS, name = "1000MC", user_name = _("1000MC"),
        model           = "GP1000",
        wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
        scheme          = "bomb-common",
        type            = 0,
        mass            = 440.0, --kg
        hMin            = 300.0,
        hMax            = 12000.0,
        Cx              = 0.00056,
        VyHold          = -100.0,
        Ag              = -1.23,
		
        fm	= {
            mass        = 475.0,
            caliber     = 0.477,
            cx_coeff    = {1.0, 0.39, 0.38, 0.236, 1.31},
            L           = 1.765,
            I           = 1/12 * 475 * 1.765 * 1.765,
            Ma          = 0.141338,
            Mw          = 2.244756,
            wind_sigma  = 30,
        },
		
        warhead         = simple_warhead(360),--, 477
		
        shape_table_data = {
            {
                name    = "1000 lb General Purpose Bomb";
                file    = "GP1000";
                life    = 1;
                fire    = {0, 1};
                username = _("1000MC"),
                index   = WSTYPE_PLACEHOLDER;
            },
        },
        targeting_data  = {
            char_time   = 20.57, -- characteristic time for sights 
        },
    }
    declare_weapon(GP1000)

    declare_loadout({category = CAT_BOMBS, CLSID = "{Lanc_1000MC}", displayName = _("1000 lbs Medium Case Bomb"),
		attribute		= GP1000.wsTypeOfWeapon,
		Count 			= 1,
		Cx_pil			= GP1000.Cx,
        Picture 		= "1000mc.png",
        PictureBlendColor = "0xffffffff",
		Weight			= GP1000.mass,
		Elements  		= {{ShapeName = GP1000.model}},
	})
    -- end of UK General Purpose High Explosive Bomb, 1000 lb GP, 1000GP ------------------


-- UK General Purpose High Explosive Bomb, 500lb GP -------------------------
AP2000 = {category = CAT_BOMBS, name = "2000AP", user_name = _("2000AP"),
        model           = "ap2000",
        wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
        scheme          = "bomb-common",
        type            = 0,
        mass            = 907.2, --kg
        hMin            = 300.0,
        hMax            = 12000.0,
        Cx              = 0.00056,
        VyHold          = -100.0,
        Ag              = -1.23,
		
        fm	= {
            mass        = 907.2,
            caliber     = 0.3,
            cx_coeff    = {1.0, 0.39, 0.38, 0.236, 1.31},
            L           = 1.765,
            I           = 1/12 * 907.2 * 1.765 * 1.765,
            Ma          = 0.141338,
            Mw          = 2.244756,
            wind_sigma  = 30,
        },
		
        warhead         = simple_warhead(60),--, yep AP bombs have very small charges
		
        shape_table_data = {
            {
                name    = "2000 lb Armor-Piercing Bomb";
                file    = "ap2000";
                life    = 1;
                fire    = {0, 1};
                username = _("2000AP"),
                index   = WSTYPE_PLACEHOLDER;
            },
        },
        targeting_data  = {
            char_time   = 20.57, -- characteristic time for sights 
        },
    }

    declare_weapon(AP2000)

    declare_loadout(
        {
            category = CAT_BOMBS, 
            CLSID = "{Lanc_2000AP}", 
            displayName = _("2000 lbs Armor Piercing Bomb"),
            attribute		= AP2000.wsTypeOfWeapon,
            Count 			= 1,
            Cx_pil			= AP2000.Cx,
            Picture 		= "2000ap.png",
            PictureBlendColor = "0xffffffff",
            Weight			= AP2000.mass,
            Elements  		= {{ShapeName = AP2000.model}},
	})
    -- end of UK 2000 lb AP Bomb ------------------


    
-- start of Cookie 4000lb bomb
cookie = 
{
        category        = CAT_BOMBS, 
        name            = "Cookie", 
        user_name       = _("4000 lb High Capacity Bomb"),
        model           = "cookie",
        wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
        scheme          = "bomb-common",
        type            = 0,
        mass            = 1815, --kg
        hMin            = 10,
        hMax            = 12000.0,
        Cx              = 0.00056,
        VyHold          = -100.0,
        Ag              = -1.23,
		
        fm	= {
            mass        = 1815,
            caliber     = 0.97,
            cx_coeff    = {1.0, 0.39, 0.38, 0.236, 1.31},
            L           = 2.92,
            I           = 1/12 * 1815 * 2.92 * 2.92,
            Ma          = 0.141338,
            Mw          = 2.244756,
            wind_time   = 220,
            wind_sigma  = 30,
            cx_factor   = 600,
        },
        warhead         = 
        {
            mass			    = 1200,
            piercing_mass       = 10,
            expl_mass           = 1190,
            other_factors       = { 1.0, 0.5, 0.5 },
            concrete_factors    = { 1.0, 0.5, 0.1 },
            concrete_obj_factor = 0.0,
            obj_factors         = { 1.0, 1.0 },
            cumulative_factor   = 3.0,
            cumulative_thickness = 0.1,
        },
         --   simple_warhead(1200),--, 477
		
        shape_table_data = {
            {
                name    = "Cookie";
                file    = "cookie";
                life    = 1;
                fire    = {0, 1};
                username = _("4000lb High Capacity Bomb"),
                index   = WSTYPE_PLACEHOLDER;
            },
        },

        targeting_data  = {
            char_time   = 20.57, -- characteristic time for sights 
        },
    }
    declare_weapon(cookie)

    declare_loadout(
        {
            category        = CAT_BOMBS, 
            CLSID           = "{Lanc_Cookie}", 
            displayName     = _("4000lb High Capacity Bomb"),
		    attribute		= cookie.wsTypeOfWeapon,
		    Count 			= 1,
		    Cx_pil			= cookie.Cx,
            Picture 		= "cookie.png",
            PictureBlendColor = "0xffffffff",
		    Weight			= cookie.mass,
		    Elements  		= {{ShapeName = cookie.model}},
	})

	-- end of Cookie
	

incendiary30lb = {  -- https://ww2data.blogspot.com/2017/01/british-explosive-ordnance-incendiary.html
        category        = CAT_BOMBS, 
        name            = "30_lbs_Incediary", 
        user_name       = _("30lbs Incendiary Small Bomb"),
        model           = "30lbs_incendiary",
        wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_A, WSTYPE_PLACEHOLDER},
        scheme          = "bomb-common",
        type            = 0,
        mass            = 13.6, --kg
        hMin            = 10,
        hMax            = 12000.0,
        Cx              = 0.00056,
        VyHold          = -100.0,
        Ag              = -1.23,

        fm	= {

            mass        = 13.6,               
            caliber     = 0.127,                 
            cx_coeff    = {1.0, 0.39, 0.38, 0.236, 1.31},
            L           = 0.8,          
            I           = 1/12 * 13.6 * 0.8 * 0.8,   
            Ix          = 0.0017991,            
            Ma          = 1.0,             
            Mw          = 0.5,            
            wind_time   = 100,   
            wind_sigma  = 180, 
            moment_sigma = 40,
            impulse_sigma = 70,
            cx_factor   = 3, 
        },

        warhead         = simple_warhead(3.6),--, 477
		
        shape_table_data = {
            {
                name    = "30lbs Incendiary";
                file    = "30lbs_incendiary";
                life    = 1;
                fire    = {0, 1};
                username = _("30lbs Incendiary"),
                index   = WSTYPE_PLACEHOLDER;
            },
        },

        targeting_data  = {
            char_time   = 20.57, -- characteristic time for sights 
        },
    }
    declare_weapon(incendiary30lb)




-- start of incendiary bomb container 
smallbomb_container = 
{
        category        = CAT_PODS, 
        name            = "Small Bomb Container", 
        user_name       = _("Small Bomb Container with 30 lb Incendiaries"),
        model           = "lanc_container",
        wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Container, WSTYPE_PLACEHOLDER},
        class_name      = "wAmmunitionBallute",
        type            = 0,
        mass            = 114, --kg
        hMin            = 10,
        hMax            = 12000.0,
        Cx              = 0.001,  -- drag coefficient, this is internal store, so neglibible
        VyHold          = -100.0,
        Ag              = -1.23,

        fm	= {
            mass        = 21,                
            caliber     = 0.12,                 
            cx_coeff    = {1, 1.2668931, 0.67, 0.4521834, 2.08}, 
            I           = 1/12 * 21 * 1.6 * 1.6,
            Ix          = 0.0017991,           
            Ma          = 0.111698,             
            Mw          = 1.2351299,           
            wind_time   = 0.625, 
            wind_sigma  = 4.85,  
        },
				
        shape_table_data = {
            {
                name    = "Small Bomb Container with 30 lb Incendiaries";
                file    = "lanc_container";
                life    = 1;
                fire    = {0, 1};
                username = _("Small Bomb Container with 30 lb Incendiaries"),
                index   = WSTYPE_PLACEHOLDER;
            },
        },

        targeting_data  = {
            char_time   = 20.57, -- characteristic time for sights 
        },
    }

    declare_loadout(
        {
        category        = smallbomb_container.category, 
        CLSID           = "{Lanc_Container}", 
        displayName     = smallbomb_container.user_name, 
		attribute		= smallbomb_container.wsTypeOfWeapon,
        wsTypeOfWeapon  = incendiary30lb.wsTypeOfWeapon,
		Count 			= 8,
		Cx_pil			= smallbomb_container.Cx,
        Picture 		= "container.png",
        PictureBlendColor = "0xffffffff",
		Weight			= smallbomb_container.mass,
		Elements  		= 
            {
                {Position = {0 ,0 ,0},
                 ShapeName = smallbomb_container.model,   IsAdapter = true,},
                {ShapeName = incendiary30lb.model,      Position = {-0.35,-0.09, 0.07},  Rotation = {0,0,0}},
                {ShapeName = incendiary30lb.model,      Position = {-0.35,-0.09,-0.07}, Rotation = {0,0,0}},
                {ShapeName = incendiary30lb.model,      Position = {-0.35, 0.09, 0.07},  Rotation = {0,0,0}},
                {ShapeName = incendiary30lb.model,      Position = {-0.35, 0.09,-0.07}, Rotation = {0,0,0}},   -- half
                {ShapeName = incendiary30lb.model,      Position = {0.45, -0.09, 0.07}, Rotation = {0,0,0}},
                {ShapeName = incendiary30lb.model,      Position = {0.45, -0.09,-0.07},  Rotation = {0,0,0}},
                {ShapeName = incendiary30lb.model,      Position = {0.45,  0.09, 0.07}, Rotation = {0,0,0}},
                {ShapeName = incendiary30lb.model,      Position = {0.45,  0.09,-0.07}, Rotation = {0,0,0}},
            },
	    })
   -- end of Container ------------------


-- Illumination flare
illum_flare = {
    category        = CAT_BOMBS, 
    name            = "Illumination Flare", 
    user_name       = _("Illumination Flare"),
    model           = "30lb_incendiary_stick",  --TODO model the flare and chute
    wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
    scheme          = "bomb-light",
    type            = 0,
    mass            = 20.0, --kg
    hMin            = 10,
    hMax            = 12000.0,
    Cx              = 0.00056,
    VyHold          = -100.0,
    Ag              = -1.23,

	fm =
	{
		mass            = 15.000000, --!!!!!
		caliber         = 0.201,
		cx_coeff        = {1.000000, 0.290000, 0.710000, 0.140000, 1.280000},
		L               = 0.60000,
		I               = 1/12 * 15.0  * 0.6 * 0.6,
		Ma              = 2.746331,
		Mw              = 2.146083,
		wind_sigma      = 0.000000,
		cx_factor   	= 2100,
	},

    warhead         = simple_warhead(1),--, 477
    
    control = 
	{
		open_delay    = 25.0,
		open_interval = 15.0,
		items_count   = 1, 
		delay_par   = 25.0,
	},
    light =
    {
        start_time  = 5.0, --!!!!!
        duration    = 170, --!!!!!
        light_position = {0.7, 0, 0}, --!!!!!
        light_color = {1, 0.8, 0.6}, --!!!!!
        light_attenuation = 1000.0, -- What is this? Should be 3 million candela ?
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 0.8,
        smoke_width = 1,
	
    },
    shape_table_data = {
        {
            name    = "Illumination Flare";
            file    = "30lb_incendiary_stick";
            life    = 1;
            fire    = {0, 1};
            username = _("Illumination Flare"),
            index   = WSTYPE_PLACEHOLDER;
        },
    },

    targeting_data  = {
        char_time   = 20.57, -- characteristic time for sights 
    },
}
declare_weapon(illum_flare)

declare_loadout(
{
	category			= CAT_BOMBS,
	CLSID				= "{Lanc_FLARE}",
	attribute			= {4,	5,	32,	32},--{wsType_Weapon,wsType_Bomb,wsType_Bomb_Lighter,wsType_LYSBOMB},--WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon		= illum_flare.wsTypeOfWeapon,
	Count				= 2,
	Picture				= "container.png",
	displayName			= _("Target Illumination Flare"),
	Cx_pil = 0.002,
	Weight				= (illum_flare.mass),
    Elements	=	{{ShapeName = illum_flare.model}},
})







--- GUNS

-- -- Browning .303 Mk. II
function Browning303 ( tbl )
    tbl.category = CAT_GUN_MOUNT
    tbl.name = "Browning303"
    tbl.display_name = _("Browning .303")

    tbl.supply = {
        shells = turret_ammo,
		mixes = {{3,3,3,2,4}},
		count = 1000,
	}

	if tbl.mixes then
		tbl.supply.mixes = tbl.mixes
		tbl.mixes = nil
	end
	if tbl.count then
		tbl.supply.count = tbl.count
		tbl.count = nil
	end
   
    tbl.gun = {
        max_burst_length = 65535,
        rates = {1140}, -- unsynchronized mount
        recoil_coeff = 1.0,
        barrel_circular_error = 0.0001,
        barrels_count = 1,
        trigger = {name ="GunTrigger"}
    }
    tbl.ejector_pos = tbl.ejector_pos or {0.0, 0.05, 0.0}
    tbl.ejector_dir = tbl.ejector_dir or {0, -1, 0}
    tbl.effect_arg_number = tbl.effect_arg_number or 436
    tbl.supply_position = tbl.supply_position or {0, 0.3, -0.3}
    tbl.aft_gun_mount = false
    tbl.effective_fire_distance = 200
    --tbl.drop_cartridge = 0 -- 204
    tbl.azimuth_initial = tbl.azimuth_initial or 0
    tbl.elevation_initial = tbl.elevation_initial or 0
    tbl.muzzle_pos = {0, 0, 0} -- all position from connector
    tbl.effects = {
        {name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
        {name = "SmokeEffect"},
    }


    return declare_weapon(tbl)
end


forbidden_payloads_ext = {    -- payloads that should be blocked in mission editor when very large bombs are equipped on station 8
	                    {	station = 1,
							loadout = {"{Lanc_1000MC}"},
						}, 
						{
							station = 2,
							loadout = {"{Lanc_1000MC}"},
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 3
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 4
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 5
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 6
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 7
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 9
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 10
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 11
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 12
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 13
						}, 
						{
							loadout = {"{Lanc_1000MC}"},
							station = 14
						}, 
												{
							loadout = {"{Lanc_1000MC}"},
							station = 15
						}, 
						{	station = 4,
							loadout = {"{Lanc_2000AP}"},
						}, 
						{
							station = 5,
							loadout = {"{Lanc_2000AP}"},
						}, 
						{
							loadout = {"{Lanc_2000AP}"},
							station = 6
						}, 
						{
							loadout = {"{Lanc_2000AP}"},
							station = 10
						}, 
						{
							loadout = {"{Lanc_2000AP}"},
							station = 11
						}, 
						{
							loadout = {"{Lanc_2000AP}"},
							station = 12
						}, 
						{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 1
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 2
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 3
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 4
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 5
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 6
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 7
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 9
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 10
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 11
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 12
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 13
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 14
						}, 
												{
							loadout = {"{British_MC_500LB_Bomb_Mk2}"},
							station = 15
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 1
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 2
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 3
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 4
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 5
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 6
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 7
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 9
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 10
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 11
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 12
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 13
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 14
						}, 
												{
							loadout = {"{British_MC_250LB_Bomb_Mk2}"},
							station = 15
						}, 
																		{
							loadout = {"{Lanc_Container}"},
							station = 1
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 2
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 3
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 4
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 5
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 6
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 7
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 9
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 10
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 11
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 12
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 13
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 14
						}, 
												{
							loadout = {"{Lanc_Container}"},
							station = 15
						}, 

					}
                
