
dofile(current_mod_path..'/Lancaster_damage.lua')  -- load damage cell descriptors
dofile(current_mod_path..'/Weapons/Lancaster_turrets.lua') -- load turret definitions

Lancaster_B1 =  {
        

	--[[ Module Attributes ]]
	Name 				=  'Lancaster',
	DisplayName			= _('Lancaster'),
	HumanCockpit 		= false,		-- not flyable
	Picture				= 'loadout.png', -- loadout picture, deprecated
	Rate 				= 40, -- RewardPoint in Multiplayer
	debrisGeneration    = true,
	Countries 			= {"USA","Canada","UK"},
	date_of_introduction = 1942,

	mapclasskey 		= "P0091000027",  -- P009100027 = Bomber, P0091000026 = Recon
	attribute = { 1, 1, 4, "Redacted", "Strategic bombers", "Bombers", "All", "NonAndLightArmoredUnits", "NonArmoredUnits", "Air", "Planes", "Battle airplanes" },

	-- visuals 
	Shape 				= "Lancaster",	 
	XRayShape           = "Lancaster_x_ray", -- "Warbird damage model" detailed hitboxes
	propellorShapeType	= '3ARG_PROC_BLUR',  -- "new prop blur"
	propellorShapeName  = 'Lanc_Prop.fbx',   -- single propeller blade for new prop blur
	shape_table_data 	= 
	{
		{
			file  	 = 'Lancaster'; -- refers to the .lods file
			life  	 = 120; 		-- lifebar hitpoints
			vis   	 = 9; 			-- visibility gain.
			desrt    = ''; 			-- Name of destroyed object file name
			fire  	 = { 600, 8}; 	-- Duration of fire on the ground after destoyed: 300sec 2m
			username = 'Lancaster';
			index    =  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap = true;

		},
	--	{
		--TODO: Destroyed model
	--		name  = "Lancaster_destr";  
	--		file  = "Lancaster-destr";
	--		fire  = { 240, 2};
	--	},
	},
	

	sounderName =  "Aircraft/Planes/Lancaster",
	InheritCommonCallnames = true, --e

	
	-------------------- Aircraft attributes ------------------------------------------------------------------------------
	EmptyWeight									=   16738,
	M_empty										=	16738, 	-- kg  --should be 16738
	M_fuel_max									=	7220,  	-- kg --2154 imperial gallons
	M_max										=	30844, 	-- kg 
	M_nominal									=	24948, 	-- kg  --should be 24948
	AmmoWeight 									=	400.4, 	-- kg (14,000 .303 cartridges x 28.6g each)
	stores_number								=	16,    	-- hardpoints
	height										=	6.25,	--m
	length										=	21.13,	--m

	wing_area									=	120.5,	--m^2 
	wing_span									=	31.09,	--m 
	wing_tip_pos 								= 	{-1.98, 1.25, 15.3},	 -- {forward/back,up/down,left/right} location of wingtip vortices
	wing_type           						=   0,    	-- FIXED_WING = 0, VARIABLE_GEOMETRY = 1, FOLDED_WING = 2, VARIABLE_GEOMETRY_FOLDED = 3
	--wing_ad_sections							=   {0, 0, 0, 1, 1, 2, 2},   -- ???

	IR_emission_coeff							=	0.1, 	-- 1.0 is IR emission of Su-27
	IR_emission_coeff_ab						=	0.1,	-- IR emission in afterburner, as fraction of Su-27 signature
	RCS											=	7, 		--m^2
	defFuelRatio								=	0.8, 	-- default fuel amount in fraction of full
	bigParkingRamp								=	true,
	brakeshute_name								=	0,
	has_afteburner								=	false, 
	has_differential_stabilizer					=	false,
	has_speedbrake								=	false,

	flaps_transmission 							= 	"Hydraulic",
    undercarriage_transmission 					= 	"Hydraulic",
	doors_transmission 							= 	"Hydraulic",
    undercarriage_movement 						= 	3, -- seconds, duration of gear extension/recraction
    bomb_bay_movement 							= 	2, -- apparently this can't be anything other than "2" or the bomb bay stops working
	doors_movement 								= 	5, 

	tanker_type									=	0, -- 1 boom, 2 probe
		 
			
------------------------ Gear ---------------------------------------------
--- tail wheel --- 
	nose_gear_pos 							 = {-10.1, -1.04, 0}, --{forward/back,up/down,left/right} coordinate of tailwheel contact point with runway,  used for initial aircraft placement
	nose_gear_amortizer_direct_stroke        =  0,		-- m, down from nose_gear_pos
	nose_gear_amortizer_normal_weight_stroke =  -0.02, 	
	nose_gear_amortizer_reversal_stroke      =  -0.05,	-- m, max strut compression
	nose_gear_wheel_diameter				 =	0.5, 	
	tand_gear_max							 =	0.577, -- radians, nosewheel steering angle 

-- main gear	
	
	main_gear_pos 							 = {2.68, -2.9, 4}, -- coordinate of main wheel contact point with runway, used for initial aircraft placement
	main_gear_amortizer_direct_stroke	     =  0,	--  down from main_gear_pos 
	main_gear_amortizer_normal_weight_stroke =  -0.1, --  0.1,
	main_gear_amortizer_reversal_stroke      =  -0.26,--  max strut compression up from main_gear_pos 
	main_gear_wheel_diameter				 =	1.5,




------------------------------ AI defs	-----------------------------------
--- performance sources: https://www.wwiiaircraftperformance.org/Lancaster/Lancaster.html
	AOA_take_off								=	0.08,--0.12,
	CAS_min										=	56,
	Mach_max									=	0.5,
	H_max										=	7315,	-- max altitude in meters
	Ny_max										=	4,		-- max G for AI
	Ny_max_e									=	8,
	Ny_min										=	-2,		-- min G for AI
	bank_angle_max								=	45,
	V_land										=	40, --34,  	-- m/s, landing speed
	V_max_h										=	109.07, --m/s, max level speed at ceiling
	V_max_sea_level								=	100.6,  --m/s, 225 mph, max level speed at sea level
	V_opt										=	89.4, 	--m/s -- cruise speed
	V_take_off									=	45,  	--m/s, 100 mph
	Vy_max										=	4.06,	-- climb speed
	range										=	1200,
	flaps_maneuver								=	0.2,
	MaxHeight 									=   7315,   -- max altitude in meters
	MaxSpeed 									=   160,
	Waypoint_Custom_Panel 						=   true,


	thrust_sum_ab								=	8224, --?? kg doesn't seem to affect flight model
	thrust_sum_max								=	8224,
	average_fuel_consumption					=	0.86, -- kg/s doesn't seem to be used any more

	
	engines_count	=	4,
	engines_nozzles ={
		[1] =
		{
			pos =     {1.0,  0.2, -8.3}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    -3, -- lenght in m
            exhaust_length_ab_K    =   0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 1
		},
		[2] =
		{
			pos =     {1.0,  0.2, -7.0}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    -3, -- lenght in m
            exhaust_length_ab_K    =   0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 1


		},
		[3] =
		{
			pos =     {1.0,  0.1, -4.2}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    3, -- lenght in m
            exhaust_length_ab_K    =    0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 2

		},
		[4] =
		{
			pos =     {1.0,  0.1, -3.0}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    3, -- lenght in m
            exhaust_length_ab_K    =    0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 2

		},

		[5] =
		{
			pos =     {1.0,  0.1, 3.0}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    -3, -- lenght in m
            exhaust_length_ab_K    =   0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 3
		},
		[6] =
		{
			pos =     {1.0,  0.1, 4.2}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    -3, -- lenght in m
            exhaust_length_ab_K    =   0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 3


		},
		[7] =
		{
			pos =     {1.0,  0.2, 7.0}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    3, -- lenght in m
            exhaust_length_ab_K    =    0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 4

		},
		[8] =
		{
			pos =     {1.0,  0.2, 8.4}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    3, -- lenght in m
            exhaust_length_ab_K    =    0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 4

		},
	},



	crew_size	 = 7,
	crew_members = {
		[1] = -- pilot 
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "bombardier_hatch", 
            pos 				= {0.0, 0.0, 0.0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view
            canopy_pos 			= {0.0, 0.0, 0.0}, -- pilot only
			ejection_order      = 1,
			can_be_playable 	= false,
			pilot_body_arg 		= 50, -- arg plays when crewman is killed, also stores crewman health status. Can be skipped for cremen without death effect. Make sure you have different death args for all killable crew.
			role 				= "pilot",
			role_display_name   = _("Pilot"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			boarding_arg 		= 38,
			drop_parachute_name	 = "pilot_raf_parachute",
			canopy_arg = 200,
			
        }, 
		[2] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "bombardier_hatch", 
            pos 				= {5.9, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {5.9, -0.52, 0},
			ejection_order      = 2,
			can_be_playable 	= false,
			pilot_body_arg 		= 460,
			role 				= "flight_officer",
			role_display_name   = _("Bombardier"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			canopy_arg = 201,
        }, 

		[3] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-4, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-4, -0.52, 0},
			ejection_order      = 3,
			can_be_playable 	= false,
			--pilot_body_arg 		= 50,
			role 				= "flight_officer",
			role_display_name   = _("Engineer"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 

		[4] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-4, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-4, -0.52, 0},
			ejection_order      = 4,
			can_be_playable 	= false,
			--pilot_body_arg 		= 50,
			role 				= "flight_officer",
			role_display_name   = _("Navigator"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 

		[5] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-4, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-4, -0.52, 0},
			ejection_order      = 5,
			can_be_playable 	= false,
			--pilot_body_arg 		= 36,
			role 				= "flight_officer",
			role_display_name   = _("Wireless Operator"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 

		[6] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-4, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-4, -0.52, 0},
			ejection_order      = 6,
			can_be_playable 	= false,
			pilot_body_arg 		= 463,
			role 				= "gunner",
			role_display_name   = _("Mid Upper Gunner"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 

		[7] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-8, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-8, -0.52, 0}, 
			ejection_order      = 7,
			can_be_playable 	= false,
			pilot_body_arg 		= 464,
			role 				= "gunner",
			role_display_name   = _("Tail Gunner"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 
	}, -- end of crew

	crew_stations = "HumanOrchestra",
	
	-- [[ Damage ]] -- 
	Damage = verbose_to_dmg_properties(Lanc_damage),  --loaded from Lancaster_damage.lua
	DamageParts = 
	{  
		 [1] = 	"Lancaster_oblomok_wing_outer_R", 
         [2] = 	"Lancaster_oblomok_wing_outer_L", 
		 [3] = 	"Lancaster_oblomok_nose",
		 [4] = 	"Lancaster_oblomok_tail",
	},		
	fires_pos = 
		{
			[1] = 	{-2.117,	-0.9,	0}, 		-- Fuselage
			[2] = 	{0.4,	0.05,	2.14},  		-- WING_R_IN
			[3] = 	{0.4,	0.05,	-2.14}, 		-- WING_L_IN
			[4] = 	{-0.82,	0.265,	2.774}, 		-- Wing center Right? 
			[5] = 	{-0.82,	0.265,	-2.774}, 		-- Wing center Right?
			[6] = 	{-0.82,	0.255,	4.274}, 		-- Wing center Left? 
			[7] = 	{-0.82,	0.255,	-4.274}, 		-- Wing outer Left?
			[8] =   {3.0,  0.2, 7.5}, 				--engine 1 contrail
			[9] = 	{3.5,  0.1, 3.7}, 				--engine 2 contrail
			[10] = 	{3.5,  0.1, -3.7}, 				--engine 3 contrail
			[11] = 	{3.0,  0.2, -7.5}, 				--engine 4 contrail
		}, -- end of fires_pos

	Failures = {},	


	--[[ Sensors ]] --

	Sensors = {},  -- radars, EO, etc

	radar_can_see_ground		=	false,
	detection_range_max			=	0,--km range of radar
	aim_error_level_bombing 	=   0.2,
	aim_error_dive_bombing	 	=   100.0,
    aim_error_ground_attack		=   100.0,	

	CanopyGeometry 			 = makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_GOOD, LOOK_GOOD),


	-- [[ radio & comms ]] --

	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		rangeFrequency = {
            {min = 100.000, max = 156.000},
            {min = 5.500, max = 10.000},
            {min = 3.000, max = 5.500},
            {min = 0.200, max = 0.500},
        },
		modulation = MODULATION_AM
	},
	panelRadio = {
        [1] = {
            ID = "SCR522",
            name = _("TR.1143"),
            displayUnits = "MHz",
            range = {min = 38.000, max = 156.000},
            channels = {
                [1] = {name = _("Channel A"),             default = 105.000, modulation = _("AM"), connect = true},
                [2] = {name = _("Channel B"),             default = 124.000, modulation = _("AM")},
                [3] = {name = _("Channel C"),             default = 131.000, modulation = _("AM")},
                [4] = {name = _("Channel D"),             default = 139.000, modulation = _("AM")},
                [5] = {name = _("A.1271 Base Frequency"), default = 108.900, modulation = _("AM")},
            }
        },
        [2] = {
            ID = "T1154R1155R1",
            name = _("T.1154N Range 1"),
            displayUnits = "MHz",
            range = {
                {min = 5.500, max = 10.000},
            },
            channels = {
                [1] = {name = _("Preset A"), default = 9.255, modulation = _("AM")},
                [2] = {name = _("Preset B"), default = 8.000, modulation = _("AM")},
                [3] = {name = _("Preset C"), default = 7.710, modulation = _("AM")},
                [4] = {name = _("Preset D"), default = 6.872, modulation = _("AM")},
                [5] = {name = _("Preset E"), default = 5.955, modulation = _("AM")},
                [6] = {name = _("Preset F"), default = 5.850, modulation = _("AM")},
                [7] = {name = _("Preset G"), default = 5.750, modulation = _("AM")},
                [8] = {name = _("Preset H"), default = 5.650, modulation = _("AM")},
            }
        },
        [3] = {
            ID = "T1154R1155R2",
            name = _("T.1154N Range 2"),
            displayUnits = "MHz",
            range = {
                {min = 3.000, max = 5.500},
            },
            channels = {
                [1] = {name = _("Preset J"), default = 5.250, modulation = _("AM")},
                [2] = {name = _("Preset K"), default = 5.000, modulation = _("AM")},
                [3] = {name = _("Preset L"), default = 4.750, modulation = _("AM")},
                [4] = {name = _("Preset M"), default = 4.500, modulation = _("AM")},
                [5] = {name = _("Preset N"), default = 4.250, modulation = _("AM")},
                [6] = {name = _("Preset P"), default = 3.250, modulation = _("AM")},
                [7] = {name = _("Preset Q"), default = 3.012, modulation = _("AM")},
                [8] = {name = _("Preset R"), default = 3.011, modulation = _("AM")},
            }
        },
        [4] = {
            ID = "T1154R1155R3",
            name = _("T.1154N Range 3"),
            displayUnits = "kHz",
            range = {
                {min = 200.000, max = 500.000},
            },
            channels = {
                [1] = {name = _("Preset S"), default = 0.444000, modulation = _("AM")},
                [2] = {name = _("Preset T"), default = 0.421000, modulation = _("AM")},
                [3] = {name = _("Preset U"), default = 0.303000, modulation = _("AM")},
                [4] = {name = _("Preset V"), default = 0.300000, modulation = _("AM")},
                [5] = {name = _("Preset W"), default = 0.270000, modulation = _("AM")},
                [6] = {name = _("Preset X"), default = 0.260000, modulation = _("AM")},
                [7] = {name = _("Preset Y"), default = 0.250000, modulation = _("AM")},
                [8] = {name = _("Preset Z"), default = 0.240000, modulation = _("AM")},
            }
        },
    },

	Guns = Guns_ext,  -- described in Lancaster_Weapons.lua

	--[[ Hardpoints & Loadouts ]]

	Pylons =     {
        pylon(1, 2, 5, -0.25, -0.5,  -- pylon #, type = (0 = rail launch, 1 = drop, 2 = internal bay), location x,y,z
            {
				connector = "Pylon1",
				use_full_connector_position=true,
	--			arg = 26 ,arg_value = 0.0  -- set this to 1.0 for bombay to be open by default and in mission editor
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser
			}),
		pylon(2, 2, 5, -0.25, 0,  -- pylon #, type = (10 = rail launch, 1 = drop, 2 = internal bay), location x,y,z
			{
				connector = "Pylon2",
				use_full_connector_position=true,
			--	arg = 26 ,arg_value = 0.0  -- set this to 1.0 for bombay to be open by default and in mission editor
			},
			{
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser

			}),
		pylon(3, 2, 5, -0.25, 0.5,  -- pylon #, type = (10 = rail launch, 1 = drop, 2 = internal bay), location x,y,z
			{
				connector = "Pylon3",
				use_full_connector_position=true,
			   
			},
			{
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb	
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser
			
			}),
		pylon(4, 2, 2.5, -0.25, -0.5,
            {
				connector = "Pylon4",
				use_full_connector_position=true,
			   
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser

			}),
		pylon(5, 2, 2.5, -0.25, 0,
            {
				connector = "Pylon5",
				use_full_connector_position=true,
			   
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" },  -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" },  -- 250lb bomb
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser


            }),
		pylon(6, 2, 2.5, -0.25, 0.5,
            {
				connector = "Pylon6",
				use_full_connector_position=true,
			   
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb 
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser
           
			}),
		pylon(7, 2, 0, 0, 0,
            {
				connector = "Pylon7",
				use_full_connector_position=true,
			   
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser

            }),
		pylon(8, 0, 0, 0, -4,
            {
			  	arg = 601,
				arg_value = 0.0 , -- by default, bay doors are visible (arg 601), but equipping very large bombs automatically removes the bay doors.												
				connector = "Pylon8",
				use_full_connector_position=true,
			  
            },
            {

				{ CLSID = "{Lanc_Cookie}",}, -- 4000lb cookie
				{ CLSID = "{Lanc_Tallboy}", arg_value = 1.0, forbidden = forbidden_payloads_ext },  -- 12000lb Tall Boy
				{ CLSID = "{Lanc_Grandslam}",arg_value = 1.0, forbidden = forbidden_payloads_ext }, -- 22000lb monstrosity
				{ CLSID = "{UPKEEP}", 		arg_value = 1.0, forbidden = forbidden_payloads_ext },  -- Lancaster's famous bouncing bomb
				{ CLSID = "{UPKEEP_INERT}", arg_value = 1.0, forbidden = forbidden_payloads_ext },  -- Lancaster's famous bouncing bomb, but inert


            }),
		pylon(9, 2, 0, 0, 0,
            {
				connector = "Pylon9",
				use_full_connector_position=true,
			   
            },
            {
				{ CLSID = "{Lanc_1000MC}"}, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, -- 250lb bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser


            }),
		pylon(10, 2, -2.5, -0.25, -0.5,
            {
				connector = "Pylon10",
				use_full_connector_position=true,
				
            },
            {
				{ CLSID = "{Lanc_1000MC}"}, 	-- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, 	-- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, 	-- 250lb bomb
				{ CLSID = "{Lanc_2000AP}"}, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser
			}),
		pylon(11, 2, -2.5, -0.25, 0,
            {
				connector = "Pylon11",
				use_full_connector_position=true,
				
            },
            {
				{ CLSID = "{Lanc_1000MC}"}, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, -- 250lb bomb
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser


			}),
		pylon(12, 2, -2.5, -0.25, 0.5,
            {
				connector = "Pylon12",
				use_full_connector_position=true,
				
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser

			}),
		pylon(13, 2, -4, -0.25, 0.5,
            {
				connector = "Pylon13",
				use_full_connector_position=true,
				
            },
            {
				--{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, -- 250lb bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser

			}),
		pylon(14, 2, -4, -0.25, 0,
            {
				connector = "Pylon14",
				use_full_connector_position=true,
				
            },
            {
				--{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, -- 250lb bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser

			}),
		pylon(15, 2, -4, -0.25, -0.5,
            {
				connector = "Pylon15",
				use_full_connector_position=true,
				
            },
            {
				--{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser

			}),
		pylon(16, 2, -6, -0.25, 0.3,
            {
				connector = "Pylon16",
				use_full_connector_position=true,
				
            },
            {
				{ CLSID = "{Lanc_FLARE}"}, -- Photo Illumination Flare
			}),
    },
	
	-- possible waypoint actions
	Tasks = {
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(AntishipStrike),
		
		
    },	
	DefaultTask = aircraft_task(GroundAttack),
	

	SFM_Data = {
		-- known info
		-- airfoil NACA 23018
		-- from xfoil
		-- http://airfoiltools.com/airfoil/details?airfoil=naca23018-il#polars
		-- 0 Cl 60kt Cd 0.02
		
				aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
				{
					Cy0			=	0.55,--0.55,   -- zero AoA lift coefficient 
					Mzalfa		=	3.2,    -- coefficients for pitch authority (Moment around z per alpha)
					Mzalfadt	=	0.8,    -- coefficients for pitch response (Moment around z per alpha increase per dt)
					kjx			=	2.6,    -- Inertia parametre X - Dimension (clean) airframe drag coefficient at X (Top) Simply the wing area in square meters (as that is a major factor in drag calculations) - smaller = massive inertia
					kjz			=	0.00125,-- Inertia parametre Z - Dimension (clean) airframe drag coefficient at Z (Front) Simply the wing area in square meters (as that is a major factor in drag calculations)
					Czbe		=	-0.016, 	-- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
					cx_gear		=	0.04,   -- coefficient, drag, gear
					cx_flap		=	0.09,   -- coefficient, drag, full flaps
					cy_flap		=	0.36,   -- coefficient, normal force, lift, flaps
					cx_brk		=	0.02,   -- coefficient, drag, brakes
					table_data  = 
					{	--      M		Cx0		 	Cya			B		 B4	    	Omxmax		Aldop		Cymax
						[1] = 	{0,		0.0224,		0.10,	0.06,		0.0001,		0.0,		15,			1.3},
						[2] = 	{0.05,	0.0224,		0.10,	0.06,		0.0001,		0.1,		15,			1.32},
						[3] = 	{0.1,	0.0224,		0.10,	0.06,		0.0001,		0.2,		17,			1.33},
						[4] = 	{0.15,	0.0224,		0.10,	0.06,		0.0001,		0.45,		17,			1.35},
						[5] = 	{0.2,	0.0224,		0.10,	0.06,		0.0001,		0.4,		15,			1.37},
						[6] = 	{0.25,	0.0224,		0.10,	0.06,		0.0001,		0.3,		15,			1.4},
						[7] = 	{0.3,	0.0224,		0.10,	0.06,		0.0001,		0.27,		15,			1.3},
						[8] = 	{0.35,	0.0224,		0.10,	0.06,		0.0001,		0.21,		15,			1.2},
						[9] = 	{0.4,	0.0224,		0.10,	0.06,		0.0001,		0.21,		14,			1.1},
						[10] = 	{0.45,	0.0224,		0.10,	0.06,		0.0001,		0.21,		13,			0.8},
						[11] = 	{0.5,	0.0224,		0.10,	0.06,		0.0001,		0.21,		12,			0.4},
						[12] = 	{1	,	0.0224,		0.10,	0.05,		0.0001,		0.14,		4,			0.2},
		
					}, -- end of table_data
-- B-17 = { 
-- { 0, 	0.025, 	0.08, 0.0324, 	1e-06, 0, 		17, 1.25 }, 
-- { 0.05, 	0.025, 	0.08, 0.0324, 	1e-06, 0.125, 	17, 1.3 }, 
-- { 0.1, 	0.025, 	0.08, 0.0324, 	1e-06, 0.25, 	17, 1.315 }, 
-- { 0.15, 	0.025, 	0.08, 0.0324, 	1e-06, 0.375, 	17, 1.319 }, 
-- { 0.2, 	0.025, 	0.08, 0.0324, 	1e-06, 0.463, 	17, 1.322 }, 
-- { 0.25, 	0.025, 	0.08, 0.0324, 	1e-06, 0.5, 	17, 1.322 }, 
-- { 0.3, 	0.025, 	0.08, 0.0324, 	1e-06, 0.473, 	17, 1.3 }, 
-- { 0.35, 	0.025, 	0.08, 0.0324, 	1e-06, 0.414, 	15, 1.194 }, 
-- { 0.4, 	0.025, 	0.08, 0.0324, 	1e-06, 0.35, 	14, 1.1 }, 
-- { 0.45, 	0.025, 	0.08, 0.0324, 	1e-06, 0.307, 	13, 0.988 }, 
-- { 0.5, 	0.025, 	0.08, 0.0326, 	1e-06, 0.277, 	11, 0.857 }, 
-- { 0.55, 	0.0278, 0.08, 0.0332, 	1e-06, 0.247, 	10, 0.752 }, 
-- { 0.6, 	0.031, 	0.08, 0.0348, 	1e-06, 0.218, 	9, 	0.644 }, 
-- { 0.65, 	0.0365, 0.08, 0.037, 	1e-06, 0.186, 	7, 	0.536 },
-- { 0.7, 	0.0438, 0.076, 0.0393, 	1e-06, 0.159, 	6, 	0.462 }, 
-- { 0.8, 	0.0567, 0.082, 0.0441, 	1e-06, 0.115, 	5, 	0.36 }, 
-- { 0.9, 	0.0723, 0.08, 0.049, 	1e-06, 0.065, 	4, 	0.332 } 
-- }



					-- M - Mach number
					-- Cx0 - Coefficient, drag, profile, of the airplane
					-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
					-- B - Polar quad coeff
					-- B4 - Polar 4th power coeff
					-- Omxmax - roll rate, rad/s
					-- Aldop - Alfadop Max AOA at current M - departure threshold
					-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
				}, -- end of aerodynamics
		
		
		engine =  -- Merlin 28 (same as Mosquito Merlin 25)        
		{
			Nmg					=	20, --idle RPM (as a % of Nominal_RPM)
			Nominal_RPM 		=   3000.0, -- redline
			MinRUD				=	0, -- minimum throttle amount
			MaxRUD				=	1, -- maximum unrestricted throttle amount
			MaksRUD				=	0.9, -- mil power throttle
			ForsRUD				=	1,
			type 				= "Piston", --[[ E_TURBOJET = 0, E_TURBOJET_AB = 1, E_PISTON = 2, E_TURBOPROP = 3, E_TURBOFAN = 4,  E_TURBOSHAFT = 5 ]]	--		
			hMaxEng				=	12.5,  -- Max altitude for safe engine operation in km
			name				= "RollsRoyceMerlin",  --used to determine sounds
			dcx_eng				=	0.015, -- Engine drag coeficient, affects drag of engine when shutdown					 
			cemax				=	0.37,   
			cefor				=	0.37,   
			dpdh_m				=	1800,
			dpdh_f				=	1800,
			k_adiab_1			= 0.0325,--0.037923, --0.0325
			k_adiab_2			= 0.042,--0.0562,   --0.042
			MAX_Manifold_P_1	= 142722,		
			MAX_Manifold_P_2	= 158406,		
			MAX_Manifold_P_3	= 182000,		
			k_after_cool		= 0.002 ,--0.54,
			Displ				= 27, -- displacement (L)
			Stroke				= 0.152, -- cylinder stroke (m)
			V_pist_0			= 12,    -- piston speed? (m/sec)
			cylinder_firing_order = { 1, 12, 4, 9, 2, 11, 6, 7, 3, 10, 5, 8 },
			Nu_0				= 1.2,
			Nu_1				= 0.9,
			Nu_2				= 0.001,
			N_indic_0			= 1023040,
			N_fr_0				= 0.072, --friction?
			N_fr_1				= 0.02,  --friction?
			Init_Mom			= 220,
			D_prop				= 4.0, 	-- meters, prop Diameter
			MOI_prop			= 80,  	-- moment of inertia of the prop
			k_gearbox			= 2.38, -- prop reduction gearbox ratio (##:1)
			P_oil				= 495000,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,
			k_Eps				= 6,

			table_data = 
			{
			   --M			--Pmax
				{0.0,		17020.0},
				{0.1,		16600.0},
				{0.2,		15340.0},
				{0.3,		14320.0},
				{0.4,		13230.0},
				{0.5,		12300.0},
				{0.6,		11600.0},
				{0.7,		11050.0},
				{0.8,		10820.0},
				{0.9,		 6902.0},
				{1.9,		 3469.0}
			},

            Startup_Prework = 10.0,

			Startup_RPMs = {
                {0.0, 0},
                {2.0, 120},
                {5.6, 120},
                {5.5, 120},
                {6.5, 1100},
                {8.5, 900},
				{13.0, 900},
				{21.0, 550},
			},
            Startup_Ignition_Time = 6.0,
            Shutdown_Duration = 6,
			prop_pitch_min		= 23.0,	-- prop pitch min, degrees 
			prop_pitch_max		= 65.0,	-- prop pitch max, degrees 
			prop_pitch_feather	= 91.0,	-- prop pitch feather position, degrees if feather < prop_pitch_max no feathering available
            prop_blades_count   = 3,
			prop_direction 	    = 1,
            prop_locations      = {
				{4.9, 0.58, -7.68}, {0.0, 0.0, 0.0},  	-- engine 1
				{5.4, 0.29, -3.64}, {0.0, 0.0, 0.0},	-- engine 2
                {5.4, 0.29, 3.64}, {0.0, 0.0, 0.0}, 	-- forward/back,up/down,left/right
                {4.9, 0.58, 7.68}, {0.0, 0.0, 0.0},	   	-- engine 4

        	},
			extended = -- engine accelerate / coast speed
			{
				rpm_acceleration_time_factor = 
                {
                    RPM  = {0, 50, 100},
                    t    = {0.3,0.5,0.3}
                },
                rpm_deceleration_time_factor = 
                {
                    RPM  = {0, 50, 100},
                    t    = {0.3,0.5,0.5}
                },
			},
		}, -- end of engine
	},
	

	lights_data = {
        typename = "collection",
        lights = {
			[1] = {
				-- landing lights
                typename = "collection",
			 	lights = { 
			 		{typename  = "argumentlight", connector = "LandingLight1",argument = 202, power_up_t = 2.8, movable = true, dir_correction = {elevation = math.rad(-1)}},	
			 		{typename  = "argumentlight", connector = "LandingLight2", argument = 203, power_up_t = 2.8, movable = true, dir_correction = {elevation = math.rad(-1)}}},	
			 	},
			[2] = {
				-- interior lighting as seen from the outside
				typename = "collection",
				lights = { 
					{typename  = "argumentlight", connector = "Cabin_Light_1",argument = 204, power_up_t = 2.8, dir_correction = {elevation = math.rad(-1)}}},
				},
			[3] = {								 
				-- navigation lights
				typename = "collection",
				lights = {
					{typename  = "argumentlight", connector = "NavLightL",argument = 256, power_up_t = 2.8, dir_correction = {elevation = math.rad(-1)}},	
					{typename  = "argumentlight", connector = "NavLightR", argument = 256, power_up_t = 2.8, dir_correction = {elevation = math.rad(-1)}}	}
				},

			-- [5] = {
			-- 		 -- Aldis aiming lights for Upkeep bouncing bomb
			-- 		typename = "collection",
			-- 		lights = { 
			-- 			{typename  = "spotlight", connector = "Upkeep_AimLight_Front",argument = 259, dir_correction = {elevation = math.rad(-1)}},	
			-- 			{typename  = "spotlight", connector = "Upkeep_AimLight_Rear", argument = 260, dir_correction = {elevation = math.rad(-1)}}	
			-- 		},
			-- },
            -- STROBES
		},
	},

	-- [[ Animations ]]
	
		encyclopediaAnimation = { -- animation in payload section in Mission Editor
        args = {
            	[26] = 1.0,
        	}
    	},


	mechanimations = {

		BombBay = {{
				Sequence = { {
						C = { { "Arg", 26, "to", 1, "in", 6.0, "sign", 1 } } 
					} },
				Transition = { "Close", "Open" }
			}, {
				Sequence = { {
						C = { { "Arg", 26, "to", 0, "in", 6.0, "sign", -1 } }
				 
					} },
				Transition = { "Open", "Close" }
			}},
		LeftStrut = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 5, "from", 0, "to", 1, "in", 8 } }
					} },
				Transition = { "Retract", "Extend" }
			}, {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 5, "from", 1, "to", 0, "in", 10 } }
					} },
				Transition = { "Extend", "Retract" }
			}, {
				Sequence = { {
						C = { { "VelType", 3 }, { "PosType", 6 }, { "Arg", 5, "to", 0.5, "speed", 2, "sign", -1 } }
					} },
				Transition = { "Any", "Collapse" }
			} },
		RightStrut = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 4 }, { "Arg", 3, "from", 0, "to", 1, "in", 8 } }
					} },
				Transition = { "Retract", "Extend" }
			}, {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 4 }, { "Arg", 3, "from", 1, "to", 0, "in", 10 } }
					} },
				Transition = { "Extend", "Retract" }
			}, {
				Sequence = { {
						C = { { "VelType", 4 }, { "PosType", 7 }, { "Arg", 3, "to", 0.5, "speed", 2, "sign", -1 } }
					} },
				Transition = { "Any", "Collapse" }
			} },
		HeadLight0 = { {
				Sequence = { {
						C = { { "Arg", 257, "to", 0, "speed", 0.1, "sign", -1 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 257, "to", 1, "speed", 0.1, "sign", 1 } }
					} },
				Transition = { "Any", "High" }
			} },
		

		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 38, "to", 0.9, "in", 5 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 38, "to", 0, "in", 3 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "Arg", 38, "set", 1 } }
					} },
				Transition = { "Any", "Bailout" }
	  
				  
								   
			} },

		Door1 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 109, "to", 0.9, "in", 5 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 109, "to", 0, "in", 3 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "Arg", 109, "set", 1 } }
					} },
				Transition = { "Any", "Bailout" }
			} },

		CrewLadder = {
			{Transition = {"Dismantle", "Erect"},	Sequence = {{C = {{"Arg", 91, "to", 1.0, "in", 3.0}}},}},
			{Transition = {"Erect", "Dismantle"},	Sequence = {{C = {{"Arg", 91, "to", 0.0, "in", 3.0}}},}},
		},
		},

	AddPropAircraft = {
	--	{id = "SoloFlight", control = 'checkbox' , label = _('Solo Flight'), defValue = false, weightWhenOn = -80},
		{id = "NetCrewControlPriority" , control = 'comboList', label = _('Aircraft Control Priority'), playerOnly = true,
		  values = {{id =  0, dispName = _("Pilot")},
					{id =  1, dispName = _("Instructor")},
					{id = -1, dispName = _("Ask Always")},
					{id = -2, dispName = _("Equally Responsible")}},
		  defValue  = 0,
		  wCtrl     = 150
		},
		{id = "H2S", control = 'checkbox' , label = _('H2S Ground Radar'), defValue = false, weightWhenOn = 120, arg = 600, wCtrl = 150}, -- TODO: find actual H2S installation weight
		{id = "Remove Bomb Bay Doors", control = 'checkbox' , label = _('Remove Bomb Bay Doors'), defValue = false, weightWhenOn = -800, arg = 601, wCtrl = 150}, 
																																					
	--	{id = "ExhaustShrouds", control = 'checkbox' , label = _('Engine Exhaust Shrouds'), defValue = false, weightWhenOn = 22, arg = 602, wCtrl = 150}, 
		{id = "Dambuster Low Altitude Aiming Lights", control = 'checkbox' , label = _('Dambuster Low Altitude Aiming Lights'), defValue = false, weightWhenOn = 0, arg = {259, 260}, wCtrl = 150}, -- 2 lamps at specific angles that produce circular reflections on the ground below, used by Dambuster flights to find correct altitude, in the dark, for the Upkeep drop.
		{id = "ResinLightYellow", control = 'checkbox', label = _('Yellow ResIn Light'), defValue = false, arg = 252, value = 0.15, wCtrl = 150},
		{id = "ResinLightGreen", control = 'checkbox', label = _('Green ResIn Light'), defValue = false, arg = 251, value = 0.15, wCtrl = 150},
		{id = "ResinLightRed", control = 'checkbox', label = _('Red ResIn Light'), defValue = false, arg = 250, value = 0.15, wCtrl = 150},

	},
}

add_aircraft(Lancaster_B1)
