
local _spring_force_multiplier = 22
local _damage_multiplier = 70

local max_takeoff_weight_kg = 16737

local tire_static_friction = 1.0
local tire_side_friction = 0.65
local tire_rolling_friction = 0.008
local tire_sliding_friction = 0.2

local main_gear_min_extension_m = 0.0
local main_gear_max_extension_m = 0.40
local main_gear_static_load_full_load_N = max_takeoff_weight_kg * 9.81 * 0.8  -- how much force is each main gear supporting when fully loaded on the ground

local main_gear_damper_compression_force = 50000.0
local main_gear_damper_rebound_force = 60000.0
local main_gear_spring_rate = 5.6e+12

local main_gear_wheel_radius = 1.4986/2

local tail_gear_static_load_full_load_N = max_takeoff_weight_kg * 9.81 * 0.4  -- how much force is each main gear supporting when fully loaded on the ground


local brake_moment = 6

Lanc_suspension = 
{
	{
        -- tailwheel
		mass  			  = 80,
		pos   			  = {-9.7,0,0},
		moment_of_inertia = {1000,1000,1000},
		
		
		damage_element	    = 83,
		damage_omega	    = 30.0,

		wheel_axle_offset 	= 0.0, 
		self_attitude	    = true,
		yaw_limit		    = math.rad(180.0),
		damper_coeff	    = 10.0,
		
		amortizer_min_length					= 0.008,  -- source https://www.youtube.com/watch?v=sgwHQbJuszo
		amortizer_max_length					= 0.2,
		amortizer_basic_length					= 0.2,
		amortizer_reduce_length					= 0.1,


		amortizer_spring_force_factor			= 1.5e+13,
		amortizer_spring_force_factor_rate		= _spring_force_multiplier, 

		amortizer_static_force					= tail_gear_static_load_full_load_N,-- mass of aircraft to Newtons times fraction of weight supported by this strut,
		amortizer_direct_damper_force_factor	= 24000.0,
		amortizer_back_damper_force_factor		= 30000.0,
		wheel_radius				   			= 0.25,

		wheel_static_friction_factor   = tire_static_friction,       
		wheel_side_friction_factor     = tire_side_friction,       
		wheel_roll_friction_factor     = tire_rolling_friction, 
		wheel_glide_friction_factor    = tire_sliding_friction,    

		wheel_damage_force_factor     = 250.0 * _damage_multiplier,        
		wheel_damage_speedX			  = 115.0,
		wheel_damage_delta_speedX     = 11.5,
		wheel_moment_of_inertia   	  = 5.6, 

		wheel_brake_moment_max = 0.0, 

		--arg_post			  = 0,
		arg_amortizer		  = 1,
		arg_wheel_yaw		  = 2,
		arg_wheel_rotation    = 76,
		collision_shell_name  = "WHEEL_REAR",
	},
	{
		-- LEFT MAIN GEAR
		mass  			  = 300,
		pos   			  = {0,-0.434,-4},
		moment_of_inertia = {100,10,100},
		
		
		damage_element	    = 84,
		wheel_axle_offset 	= 0.00,
		self_attitude	    = false,
		yaw_limit		    = 0,
		damper_coeff	    = 30.0,
		

		amortizer_min_length					= main_gear_min_extension_m,    -- from AP2062  -- (m) fully compressed length of shock/spring (1 arg value of the suspension animation)
		amortizer_max_length					= main_gear_max_extension_m, 	-- from AP2062  -- (m) fully extended/drooped length of shock/spring (0 arg value of the suspension animation)
		amortizer_basic_length					= main_gear_max_extension_m,	-- from AP2062  -- (m) fully extended/drooped length of shock/spring (0 arg value of the suspension animation)			   
		amortizer_reduce_length					= main_gear_max_extension_m*0.9,   

		amortizer_spring_force_factor			= main_gear_spring_rate,
		amortizer_spring_force_factor_rate		= _spring_force_multiplier, --20.0,

		amortizer_static_force					= main_gear_static_load_full_load_N,-- mass of aircraft to Newtons times fraction of weight supported by this strut
		amortizer_direct_damper_force_factor	= main_gear_damper_compression_force,
		amortizer_back_damper_force_factor		= main_gear_damper_rebound_force,


		wheel_radius				   = main_gear_wheel_radius ,
		wheel_static_friction_factor   = tire_static_friction,       --0.65,
		wheel_side_friction_factor     = tire_side_friction,       --0.65 ,
		wheel_roll_friction_factor     = tire_rolling_friction, -- (unitless) Rolling friction factor when wheel moves - rotating/rolling/turning wheels - no brake - lowest value - all ok - plane rolling on taxiway
		wheel_glide_friction_factor    = tire_sliding_friction,      --glide/slide friction factor when wheel not rolls/ not rotating but sliding - means fully braked, wheels cant roll - non static/aircraft is moving - therefore 2nd highest value 

		wheel_damage_force_factor     = 1000.0 * _damage_multiplier,--250.0,
		wheel_damage_speedX			  = 115.0,
		wheel_damage_delta_speedX     = 11.5,
		wheel_moment_of_inertia   	  = 320, --wheel moi as rotation body
		wheel_kz_factor				  = 0.5,


		wheel_brake_moment_max = brake_moment, -- maximum value of braking moment  , N*m 
		
	
		arg_post			  = 3,
		arg_amortizer		  = 4,
		arg_wheel_rotation    = 102,
		arg_wheel_yaw		  = -1,
		collision_shell_name  = "WHEEL_L",
	},
	{
		mass  			  = 300,
		pos   			  = {0,-0.434,4},
		moment_of_inertia = {100,10,100},
		
		
		damage_element	    = 85,
		wheel_axle_offset 	= 0.00,
		self_attitude	    = false,
		yaw_limit		    = 0,--math.rad(89.0),
		damper_coeff	    = 30.0,
		

		amortizer_min_length					= main_gear_min_extension_m, -- from AP2062  -- (m) fully compressed length of shock/spring (1 arg value of the suspension animation)
		amortizer_max_length					= main_gear_max_extension_m, -- from AP2062  -- (m) fully extended/drooped length of shock/spring (0 arg value of the suspension animation)
		amortizer_basic_length					= main_gear_max_extension_m, -- from AP2062  -- (m) fully extended/drooped length of shock/spring (0 arg value of the suspension animation)			   
		amortizer_reduce_length					= main_gear_max_extension_m*0.9,   

		amortizer_spring_force_factor			= main_gear_spring_rate,
		amortizer_spring_force_factor_rate		= _spring_force_multiplier, --20.0,

		amortizer_static_force					= main_gear_static_load_full_load_N,-- mass of aircraft to Newtons times fraction of weight supported by this strut
		amortizer_direct_damper_force_factor	= main_gear_damper_compression_force,
		amortizer_back_damper_force_factor		= main_gear_damper_rebound_force,


		wheel_radius				   = main_gear_wheel_radius , -- from AP2062, wheel 24" radius, tire 17.5" height (all x2)
		wheel_static_friction_factor   = tire_static_friction,      
		wheel_side_friction_factor     = tire_side_friction,      
		wheel_roll_friction_factor     = tire_rolling_friction, 
		wheel_glide_friction_factor    = tire_sliding_friction,     

		wheel_damage_force_factor     = 1000.0 * _damage_multiplier,--250.0,
		wheel_damage_speedX			  = 115.0,
		wheel_damage_delta_speedX     = 21.5,
		wheel_moment_of_inertia   	  = 320, 
		wheel_kz_factor				  = 0.5,

		wheel_brake_moment_max = brake_moment, -- maximum value of braking moment  , N*m 


		arg_post			  = 5,
		arg_amortizer		  = 6,
		arg_wheel_rotation    = 103,
		arg_wheel_yaw		  = -1,
		collision_shell_name  = "WHEEL_R",
	},
}



